local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		mods = {
			{0, '2.25x,*0.3 150% tiny'},
			{8, '*0.1 no tiny'},
			{16, '*99 200% beat'},
			{24, 'no beat,*2 -500% tiny'},
			{28, '*4 no tiny'},
			{31, '*2 dark'},
			{32, '*8 200% hidden,*8 200% sudden'},
			{60, '*5 no hidden,*5 no sudden'},
			{64, 'no dark,-500% Reverse,Centered,*10000 0.1x,*32 -3000% Bumpy,55% Distant'},
			{80, '*99 no drunk'},
			{95.75, '*99 no drunk'},
			{96, '*99 250% beat'},
			{112, '*99 no drunk'},
			{120, 'no beat'},
			{123, '*99 no reverse,*3 no centered,*3 2.25x,*99 no bumpy,*8 200% hidden,*8 200% sudden,*8 overhead'},
			{157, '*8 no hidden,*8 no sudden'},
			{160, '*99 distant'},
			{160.25, '*2 overhead'},
			{161.5, '*99 hallway'},
			{161.75, '*2 overhead'}
		}

drems={{32,59},{124,156}}

for i,v in pairs(drems) do
    for beat=v[1],v[2] do
        table.insert(mods,{beat, '*10 -100% suddenoffset,*10 -100% hiddenoffset'})
		table.insert(mods,{beat + 0.5, '*10 200% suddenoffset,*10 200% hiddenoffset'})
    end
end

drunkish={{79,79.75},{93.5,95.25},{111,111.75}}

for i,v in pairs(drunkish) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, '*99 500% drunk'})
        table.insert(mods, {beat + 0.25, '*99 -500% drunk'})
		table.insert(mods, {beat + 0.5, '*99 500% drunk'})
        table.insert(mods, {beat + 0.75, '*99 -500% drunk'})
    end
end

		local skewxEnd = function()
			for i=1, #players do
				players[i]
					:linear(2)
					:skewx(10)
			end
		end

		actorCmds = {
			{163.5, skewxEnd}
		}

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
